# Vespucci 20.1 Highlights

2024-07-01

### End of support for Android 4.1 to 4.4

This version removes support for Android 4.1 to 4.4. While we aspire to maintain backwards compatibility as long as reasonably possible, 4.4 was released in October 2013 and is now more than a decade old, these versions have issues with support of more recent TLS variants and certificates and in practical terms were likely only to work on private instances of the OSM API. This has allowed us to remove some version specific code and the _legacy_ build for pre-Android 5 devices.

### Android 14/API 34

As per google requirements, version 20.1 targets Android 14/API 34. For new installs on Android 14 and later devices this will add a further option to the Android permissions modal for photo and video access: "Select photos and videos". This allows users to limit which media is access by an app, and will work with Vespucci too, but will only have an effect if you are including images outside of the ones directly recorded by Vespucci by enabling the [_Use the mediastore_](http://vespucci.io/help/en/Advanced%20preferences/#use-the-mediastore) preference.

### Workaround issues with sites using Letsencrypt certificates on Android 7 and earlier

Android devices running Android 7 and earlier do not trust the root certificates used to sign new or re-issued Letsencrypt certificates since earlier this year, leading to failures to down-/upload data to the OpenStreetMap API and to authenticate with the OpenStreetMap site since the beginning of June. The later being particular annoying as google decided to simply show a blank screen in webviews for SSL errors due to untrusted certificates instead of displaying an error message.

Version 20.1 contains workarounds for both issues (and displays an error message if this happens again in the future for any of the usages of webviews in the app).

Note that both submitting crash dumps and the feedback mechanism currently don't work on pre-Android 7 devices as they are provided by 3rd party libraries, we may be able to address this for the production release.

_Both workarounds were backported to 20.0_

### Workaround issues with certain launchers restarting instead of resuming the app

On certain devices and Android versions if you switch to a different app while in Vespuccis _Property Editor_ and then return to Vespucci by clicking the app icon in the launcher, the app will be restarted instead of being resumed losing any unsaved changes made in the _Property Editor_ in the process. Selecting Vespucci from the _recent apps_ will in our experience always resume the app, but to avoid the issue on affected devices we've added a workaround that you can enable in the [_Experimental_ section of the preferences](http://vespucci.io/help/en/Advanced%20preferences/#experimental). 

Enabling this option starts the _Property Editor_ in the same mode we use for split-window support and __experimentally__ seems to avoid the issues on some of the devices that are affected by the issue. As this uses a different method to communicate back to the main map display than previously (the same as we use in split-window mode) we haven't made this the default at this point in time and would like have some more feedback from our users before doing so.

It should be noted that this and similar issues have been an ongoing problem with Android since Android API 1 and are totally outside of our control.

For some indication if your device could be affected see [testing on selected devices](http://vespucci.io/tutorials/faq/#resuming-the-app-doesnt-bring-me-back-to-the-property-editor).

_This workaround was backported to 20.0_

### Forced configuration change to OAuth 2

As the OpenStreetMap API on openstreetmap.org no longer supports any other authorization mechanism than OAuth 2, the corresponding API configurations (default and sandbox) are now forced migrated to OAuth 2. As a consequence you will need to have the login and password for your OSM account available the next time you want to upload, or you can naturally execute [Authorize OAuth](http://vespucci.io/help/en/Main%20map%20display/#tools) from the _Tools_ menu at any time before that.

### UI changes

#### Re-arrange entries in the layer modal with drag and drop

Entries in the layer modal can be moved by long pressing and then dragging the entry to its new position. You will get a visual cue when you have pressed long enough by a dimmed image of the entry appearing.

#### Re-arrange relation members with drag and drop

In the _Members_ tab in the _Property Editor_ (present when you are editing a _Relation_) you can now re-arrange member entries per drag and drop. As above you can start the process with a long press, however you will not be shown an image before you actually start dragging (that is Android for you). 

#### Default set of keys used for the nearby POI display configurable

In the absence of a filter being set the _nearby POI display_ uses a default set of keys for which it will display entries. This makes sense as you typically don't want to display entries for all objects on the screen, just for those that have _POI_ character, but work flows differ and to accommodate a wide range of uses we've now made the set of keys configurable in the _Preferences_ in _Nearby POI display_.

#### Validation styling highlights instead of replacing normal styling

Previously the colors returned by the [validation styling](http://vespucci.io/tutorials/data_styling/#validation-styling) replaced the normal styling of an object, in some cases making affected objects difficult to manipulate. We have changed this to use the colors as a highlight "behind" the normal element rendering which seems to work better. 

#### Value selectors for direction and integers

Providing dedicated selector UIs for values in OpenStreetMap is not straight forward as there is no formal typing system and a value can have literally any value representable by an UTF-8 string. 

For example a selector for the value of the the _layer_ tag needs to equally be able to deal with numbers as with the string _I don't like integers_ . The approach we have taken in the past and intend to continue in the future is to provide UI support for the selection of existing and preset derived values and provide free form input via the _Details_ tab. For this release we've added two dedicated modals for entering _integer_ and _direction_ values (this can be set in the presets) replacing previous text only entry.

##### Direction values

This provides input either of tag specific values via a conventional single choice radio button selector or via a compass direction display below it, besides using any built in magnetic compass to determine the value or you can simply drag the display to the correct value.

##### Integer values  

This provides input of tag specific values  as above, or selection of a whole number via a number picker.

#### Rendering of direction values

Elements with a direction tag that contains a degree value are now rendered with a pointer in the the direction.

#### Support for rotating nodes with a direction tag and multiple elements and relations 

Selected nodes with a direction tag, multiple elements and relations now support rotation just a previously available for ways.

#### Per-preset item support for pre-filling tags with default values

We now support setting a preferred behaviour on how to handle pre-filling tag values with either the previously used or the default value. 

This is again a case of one size doesn't fit all, so you can now turn on pre-filling on a per preset item base. In the _most recently used_ display a long press will display three options (instead of previously simply removing the item from the display): 

- _Apply with last values_ apply the item using previously used values or defaults (persistent)
- _Apply with optional_ apply the item with optional tags (persistent)
- _Remove_ remove item from MRU display 
 
Note that pre-filling will only have an effect on tags without a value.

### Improved _Todo_ support

The _Todo_ support has been re-factored to support

- editing of the comment field
- easier skipping of todos (both in the modal as in the menu associated with any references OSM element)

To make skipping a bit more useful the sorting to determine the nearest _Todo_ to display with sort open items before skipped ones.

#### Facility to create Todos from the objects in a GeoJSON layer

In some situations it is useful to work through a set of GeoJSON objects in the manner of todos, we now support creation of _Todos_ from objects in a GeoJSON layer. You can either use a built in conversion that will create a _Todo_ with a comment containing the GeoJSON properties, or use JavaScript to run a custom conversion. The later is particularly useful if the GeoJSON has references to OSM objects and you want to create Todos that will directly references these. 

See [sample conversion script](https://github.com/MarcusWolschon/osmeditor4android/blob/master/documentation/docs/tutorials/other/conversion-example.js).

## Miscellaneous

- Add support for multi-line preference titles
- Add support for labels for all GeoJSON geometries
- Indicate in the taginfo project file if an entry is "not recommended" (aka deprecated)

# Upgrading from previous versions

As a general precaution you should upload any pending changes before updating, particularly if you are upgrading from any major version that doesn't immediately precede this one. 

# Known problems

* The documentation is out of date.
* For other known problems with this build please see [our issue tracker](https://github.com/MarcusWolschon/osmeditor4android/issues)
